/*
* AEMap.jsx
* Version 0.3.1
* An After Effetcs CS4 - CS6 Dockable Scripts Panel for Equirectangular Map Creation 
* Copyright (c)  2012 Fabian "fabiantheblind" Morón Zirfas
* Permission is hereby granted, free of charge, to any person obtaining a copy of this
* software and associated documentation files (the "Software"), to deal in the Software 
* without restriction, including without limitation the rights to use, copy, modify
* copies of the Software, and to permit persons to whom the Software is furnished to do so,
* subject to the following conditions:
* The above copyright notice and this permission notice shall be included in all copies 
* or substantial portions of the Software.
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
* INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
* HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
* CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
* OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* see also http://www.opensource.org/licenses/mit-license.php
*
*/

// UI BUILD WITH http://crgreen.com/boethos/

{
    var theglobalscriptname     =       "AEMap.jsx v0.3.1";
    var thedlglobalwebsite      =       "http://aescripts.com/aemap/";
    var thehelpglobalwebsite    =       "http://fabiantheblind.github.com/AEMap/";
        run_script(this);

function run_script(thisObj){

/**
 * First we have to do some legal stuff
 * go to the end of the script to se the dialog
 *
 */
var res = null; var settingsSectionName = "aemaplic";
if((app.settings.haveSetting(settingsSectionName,"licaccept") == true)){
var licres = parseInt(app.settings.getSetting(settingsSectionName,"licaccept"));
if (licres==1){ res = [true,true];} else {res = licenseDiag(theglobalscriptname);};}else{
  res = licenseDiag(theglobalscriptname);};if (!res[1]){return;}if(res[0]){
    app.settings.saveSetting(settingsSectionName,"licaccept",1);}


    // this is some prechecking for the enclosed datafiles
var path            = ((new File($.fileName)).path);
var testfile        = File( path+"/world_geo_json/countries.geo.json");

 // ------------ if the file does not exist close the script ------------
if(!testfile.exists){
       alert("The file \"GEOJson.geo.json\" does not exist or is not at the right place.\n"+
        "it should be in a folder next to this script file like this: \"/world_geo_json/countries.geo.json\".\n"
        +"go to:\n"+thedlglobalwebsite+"\n"+ "and load the full package");
return;
}


///   THIS WILL CHECK IF PANEL IS DOCKABLE OR FLAOTING WINDOW  
   var win   = buildUI(thisObj);
   if ((win != null) && (win instanceof Window)) {
      win.center();
      win.show();
      }; // end if win  null and not a instance of window 
   }; // end run_script



//~   _    _ _____ 
//~  | |  | |_   _|
//~  | |  | | | |  
//~  | |  | | | |  
//~  | |__| |_| |_ 
//~   \____/|_____|
//~                

function buildUI(thisObj) { 
var DEBUG                     = false;
var STROKE                    = false;
var ZORRO                     = false;
var THREEDEE                  = false;
var TIMESTAMP                 = false;
var PRECOMPOSE                = false;
var SINGLELAYER               = true;
var USESHAPELAYERS            = true;
var LINKBOOL                  = false;
var REPOSANCHORBOOL           = false;
var COMPNAME                  = "brave new world";
var DUR                       = 23;
var FPS                       = 25;
var RANDOMCOLORS              = false;
var HSLCOLORS                 = false;
var SCALE                     = 3;
var RANGE                     = 360;
var ROFFSET                   = 0;
var SATURATION                = 55;
var LIGHTNESS                 = 66;
var BLACK                     = [0,0,0];
var WHITE                     = [1,1,1];
var GREY                      = [0.5,0.5,0.5];
var DARKGREY                  = [0.25,0.25,0.25];
var LIGHTGREY                 = [0.75,0.75,0.75];
var RED                       = [1,0,0];
var GREEN                     = [0,1,0];
var BLUE                      = [0,0,1];
var GUAVE                     = [0.95,0.55,0.50];
var SELECTEDCOLOR             =  BLACK;
var SELECTEDCONTOURCOLOR      =  WHITE;
var CONTOURLIKEFILLBOOL       = false;
var THESELECTEDFILENAME       = "countries.geo.json";
var CCRGBBool                 = false;
var CCHSLBool                 = false;
var CCCRGBBool                = false;
var CCCHSLBool                = false;
var NOFILLBOOL                = false;

 // ------------ the custom color objects ------------

var CCRGB   = new CustomRGBColorObject(255,255,255);
var CCHSL   = new CustomHSLColorObject(360,100,100);
var CCCRGB  = new CustomRGBColorObject(255,255,255);
var CCCHSL  = new CustomHSLColorObject(360,100,100);

// ------------ for help website call ------------
  var winProgramFiles         = Folder.commonFiles.parent.fsName;
  var winBrowserCmd           = winProgramFiles + "\\Internet Explorer\\iexplore.exe";// You can change the browser to use on windows here, use double slashes
  var macBrowserCmdStart      = "osascript -e 'open location \"";
  var macBrowserCmdEnd        = "\"'";


// ------------ UI Strings ------------
var version                   = 0.31;

var WEBSITE                   = "http://fabiantheblind.github.com/AEMap/";
var paneltitle                = "AE Map " + version + " alpha";
var numOfPrecomps             = 179;
var numOfPolygons             = 287;


// ------------ ERROR STRINGS ------------
var HELPTEXT                  = "Need help with "+paneltitle+"? I will try to open "+WEBSITE+" 4 you.\n"+
                              "\nUse the Options to customize your map. read the helptips";
var ERRORrof                  = "please use only digits for the offset.\noffset is set to: ";
var ERRORrange                = "please use only digits for the range.\nrange is set to: ";
var ERRORscale                = "please use only digits for the scale."+
                              "\n(e.g.: 3.55 thats near 1280"+
                              "\nor just 1. thats 360x180)"+
                              "\nscale is set to: ";
var ERRORsat                  = ".No no my friend letters are no digits. please use only digits between 0 - 100 for the saturation.\nsaturation is set to: "; 
var ERRORlghtn                = "Brighter than 100%?.please use only digits between 0 - 100 for the lightness.\nlightness is set to: ";
                
  var ERRORname               = "oh-oh. There is no name for your comp.\ncomp name is set to: ";   
var ERROR2big                 = "autsch. your scale is bigger than 80. This results in a comp of 28800 pixels width."+
                                "\nare you shure that is right?Use 10 for a 3600x1800 comp\nscale is set to: ";
var ERROR2small               = "ups. your scale is smaller than 0.1. THis will result in a comp of 36x18 pixels."+
                                "\nAre you shure that is right? Use 1 for a 360x180 comp\nscale is set to: ";
var ERRORreadmeexec           = "hm...the readme file is not there.\nwhat a shame\ndid i mention the website?\n"+WEBSITE;
var ERRORdur                  = "please use only digits for the duration. like 10.25 or 1.0 .\nduration is set to: ";;
var ERROR2short               = "give it at least 0.1 man. Dont have a cow man! Shortening you comp is easy...";
var ERROR2long                = "After Effetcs cant handle comps longer than 3 hours.(I heard somewhere)\nduration is set to: ";
var ERRORscaleNotInt          = "BE AWARE!\n if your scale factor does not create integer values for the composition the script will floor the compsize."+
                                " (This is why this message appeared. If your scale fits i would not complain)"+
                                "\nThe relations of the map are not affected.\nRight now your result will be:";
var ERRORcs4longnametmsp      = {
                                "alertString":function(nm){
                                  var str = "You are in CS4 and want to use timestamps?\nThan you should use names as short as possible.\n"+
                                "AE CS4 has problems with names that get longer than 27 characters\n"+
                              "I will truncate you compname ot: \"" + nm + "_XXXXXXXXXXXXX\" <-- This will be the timestamp";return str}
                              };
var ERRORcs4longcompname      = {"alertString":function(nm){
                                  var str = "You are in CS4 and want to use a very long name.\nYou should use names as short as possible.\n"+
                                  "AE CS4 has problems with names that get longer than 27 characters\n"+
                                  "I will truncate you compname to: \"" + nm+"\"";return str}
                                };
var ERRRORnofillwithsolids    = "Sorry this works only with shape layers.";
var ERRORcccolorsettoNAN      = {"alertString": function(nm, val){
                                  var str = "Oh. " + nm+ " was not set to a number. It will be reset to: " +val+ "\n please try again";return str;}
                                };

// ------------ Help TIP STRINGS ------------
var TIProffset                = "Define an offset for the hsl range.\nit starts with red at 0";
var TIPrange                  = "Define an range for the hsl range.\n0 - 360 is one full range";
var TIPlght                   = "Define an lightness for the hsl range.\n0 - 100 works";
var TIPsat                    = "Define an saturation for the hsl range.\n0 - 100 works";
var TIPcpick                  = "Selcet a preset color or use random or hsl colors\nthere are also themes. they just add some settings. "+
                                "Dont worry if it flips back to hsl colors";
var TIP3d                     = "Makes all the layers 3D and activates the continous rasterization";
var TIPtmstmp                 = "Adds a unique timestamp to the name of the comp and the folder";
var TIPzorro                  = "Add tags. Zorro Style!\n checkout Zorro - The Layer Tagger @ aescripts.com";
var TIPstroke                 = "Adds a stroke effect to the polygon layers and a controller in the master comp. The uplink is via expression."+
                                "\nWARNING: 286 layers with a stroke effect and each with 6 expressions will need a lot of render power";
var TIPprcmp                  = "If this is checked all the "+numOfPolygons+" solids will be precomposed into "+ numOfPrecomps +" jurisdictions";
var TIPcmpnm                  = "Enter a name for the comp";
var TIPscale                  = "Enter a factor for the scale.\ne.g. 2.5 - 1 means 360x180. Do the math.\n maxium is 80 / min is 0.1";
var TIPdur                    = "Enter a value for the duration like 10.5 or 2.3 or one. Messured in seconds.";
var TIPsinglelyr              = "If checked all the mask will be created on one single layer.\nIt will deactivate zorro tags and precompose!\n(In a upcoming version the values of zorro and precompose will stay. Right now it has to be like this. Sry)";
var TIPuseshapelayers         = "If you check this box the script will use shape layers insted of masks";
var TIPfpsddl                 = "Select a framerate for your new comp";
var TIPRed                    = "define a custom value for the RED channel. this field accepts integer values between 0 and 255";
var TIPGreen                  = "define a custom value for the GREEN channel. this field accepts integer values between 0 and 255";
var TIPBlue                   = "define a custom value for the BLUE channel. this field accepts integer values between 0 and 255";
var TIPCCHue                  = "define a custom value for the Hue. this field accepts integer values between 0 and 360";
var TIPCCSat                  = "define a custom value for the Saturation. this field accepts integer values between 0 and 100";
var TIPCClight                = "define a custom value for the Lightness. this field accepts integer values between 0 and 100";
var TIPSelector               = "Select one of the 4 views. Comp Settings / Fill Color Settings / Contour Color Settings or All Settings. AllSettings holds all controls.";
var TIPRepositionanchors      = "This repositions the anchor to the layer. This is based on the \"RepositionAnchorPoint\" script by Charles Bordenave.\nHave a look at the original script here: http://aescripts.com/repositionanchorpoint/\nThanx a lot for sharing that code";
var TIPlinkcheckbox           = "If checked all the stroke properties get linked to a master controller within the new comp";


 // ------------ The Settings Strings ------------
 var UIsettingsStrings = {
  "threedee"        : "3D?",
  "singlelayer"     : "Single Layer?",
  "useshapelayers"  : "Use Shape Layers?",  
  "tmstmp"          : "Use Timestamp?",
  "addstroke"       : ["Add Stroke Effect?" , "Add Stroke Prop.?"], 
  "zorro"           : "Add Zorro Tags?", 
  "precompose"      : "Precompose?",
  "repos"           : "Reposition Anchors?",
  "link"            : "Link Stroke Props?"
  };

// ------------ Color Picker STRINGS ------------
var colorslist = new Array();

colorslist.push("Black  ");//0
colorslist.push("White  ");//1
colorslist.push("Grey  ");//2
colorslist.push("Light Grey ");//3
colorslist.push("Dark Grey ");//4
colorslist.push("Red  ");//5
colorslist.push("Green ");//6
colorslist.push("Blue "); //7
colorslist.push("Guave - (not only food! also a color)");//8
// than comes a separator // 9
colorslist.push("Random - (sets random colors)"); //10
colorslist.push("HSL colors - (define a range and offset)"); //11
colorslist.push("HSL Theme - lilac to red");//12
colorslist.push("HSL Theme - paleish greenish - sick ocean");//13
colorslist.push("HSL Theme - strong blue - wide");//14
colorslist.push("HSL Theme - strong red yellow green - pastafari baby!"); //15
// than comes a separator // 16
colorslist.push("Custom HSL Color..."); //17
colorslist.push("Custom RGB Color..."); //18
// another separator // 19
colorslist.push("No Fill - Works only with ShapeLayers"); // 20

// ------------ the contour colorpicker strings ------------
var contourcolorslist = new Array();

contourcolorslist.push("Black  ");//0
contourcolorslist.push("White  ");//1
contourcolorslist.push("Grey  ");//2
contourcolorslist.push("Light Grey ");//3
contourcolorslist.push("Dark Grey ");//4
contourcolorslist.push("Red  ");//5
contourcolorslist.push("Green ");//6
contourcolorslist.push("Blue "); //7
contourcolorslist.push("Guave - (not only food! also a color)");//8
// a separator
// than comes a separator
contourcolorslist.push("Custom HSL Color..."); //10
contourcolorslist.push("Custom RGB Color..."); //119

// the settings selector list
var settingsddllist = new Array();
settingsddllist.push("Comp Settings");
settingsddllist.push("Fill Settings");
settingsddllist.push("Contour Settings");
settingsddllist.push("All Settings");

var fpslist = new Array(8,12,15,23.976,24,25,29.97,30,50,59.94,60);
var fpsliststr = new Array();
for (var i in fpslist){fpsliststr.push(" fps: " + String(fpslist[i])+"");}
// fpslist.push();

    var win = (thisObj instanceof Panel) ? thisObj : new Window('palette', paneltitle,[0,0,290,685]); 

if (win != null) { 
    // ------------ The options the user can set ------------


// ------------ ui global stuff ------------

var comppanelsize            = [10,65,275,305];
var colpanelsize             = [10,65,275,255];
var contourpanelsize         = [10,65,275,195];

var allpanelcolpanelsize     = [10,310,275,505];
var allpanelcontourpanelsize = [10,510,275,645];
var labelcompsetpos          = [10,310,275,325];
var labelcolsetpos           = [10,260,275,275];
var labelcontoursetpos       = [10,200,275,215];
var labelallsetpos           = [10,650,275,680];


win.versionlabel = win.add('statictext',            labelcompsetpos,'version ' +  version);
win.drawmap = win.add('button',                     [ 10,5,275,35], 'Draw The Map!'); 
win.help = win.add('button',                        [10,40,95,60], 'Open Help?');
win.selector = win.add('dropdownlist',              [100,40,275,60],settingsddllist);
win.selector.selection = 0;


// ------------ the panels selected by ddl------------
win.settingspanel = win.add('panel',comppanelsize , '', {borderStyle: "etched"}); 

win.settingspanel.visible = true;

win.colorspanel = win.add('panel', colpanelsize, '', {borderStyle: "etched"});

win.colorspanel.visible = false;

win.contourpanel = win.add('panel', contourpanelsize,'', {borderStyle: "etched"});

win.contourpanel.visible = false;


win.selector.onChange = function() {
  // ------------ comsettings only ------------
    if (this.selection == 0){
      win.settingspanel.visible     = true;
      win.colorspanel.visible       = false;
      win.contourpanel.visible      = false;
      win.settingspanel.bounds      = comppanelsize;
      win.versionlabel.bounds       = labelcompsetpos;
      win.colorspanel.text          = "";
      win.contourpanel.text         = "";
      };
// ------------ fill only ------------
    if (this.selection == 1){
      win.settingspanel.visible     = false;
      win.colorspanel.visible       = true;
      win.contourpanel.visible      = false;
      win.colorspanel.bounds        = colpanelsize;
      win.versionlabel.bounds       = labelcolsetpos;
      win.colorspanel.text          = "";
      win.contourpanel.text         = "";
      };

    if (this.selection == 2){
      win.settingspanel.visible     = false;
      win.colorspanel.visible       = false;
      win.contourpanel.visible      = true;
      win.contourpanel.bounds       = contourpanelsize;
      win.versionlabel.bounds       = labelcontoursetpos;
      win.colorspanel.text          = "";
      win.contourpanel.text         = "";
      };

      // ------------ allsettings full ui ------------
    if (this.selection == 3){
      win.settingspanel.visible     = true;
      win.colorspanel.visible       = true;
      win.contourpanel.visible      = true;
      win.colorspanel.text          = "fill color(s)";
      win.contourpanel.text         = "contour color";
      win.colorspanel.bounds        = allpanelcolpanelsize;
      win.contourpanel.bounds       = allpanelcontourpanelsize;
      win.versionlabel.bounds       = labelallsetpos;
    };
  }; // END SELECTOR ON CHANGE


 // ------------ the comp settings UI------------

win.threedee            = win.settingspanel.add('checkbox',  [  8, 10,138, 30], UIsettingsStrings.threedee);
win.singlechbx          = win.settingspanel.add('checkbox',  [  8, 35,138, 55], UIsettingsStrings.singlelayer); 
win.useshapelayers      = win.settingspanel.add('checkbox',  [  8, 60,138, 80], UIsettingsStrings.useshapelayers);
win.tmstmp              = win.settingspanel.add('checkbox',  [  8, 85,138,105], UIsettingsStrings.tmstmp); 
win.addstroke           = win.settingspanel.add('checkbox',  [  8,110,138,130], UIsettingsStrings.addstroke[1]); 
win.zorro               = win.settingspanel.add('checkbox',  [  8,135,138,155], UIsettingsStrings.zorro);
win.prcmpchbx           = win.settingspanel.add('checkbox',  [  8,160,138,180], UIsettingsStrings.precompose);
win.reposanchorcheckbox = win.settingspanel.add('checkbox',  [  8,185,138,205], UIsettingsStrings.repos);
win.linkcheckbox        = win.settingspanel.add('checkbox',  [  8,210,138,230], UIsettingsStrings.link);


win.compnamelabel     = win.settingspanel.add('statictext',  [139, 13,249, 30], '- Comp Name -'); 
win.compname          = win.settingspanel.add('edittext',    [139, 30,249, 50], COMPNAME); 
win.scalefaclabel     = win.settingspanel.add('statictext',  [139, 53,249, 70], '- Scale -'); 
win.scalefacval       = win.settingspanel.add('edittext',    [139, 70,249, 90], String(SCALE)); 
win.durlabel          = win.settingspanel.add('statictext',  [139, 93,249,110], '- Duration in Sec -'); 
win.durval            = win.settingspanel.add('edittext',    [139,110,249,130], String(DUR)); 
win.fpsddl            = win.settingspanel.add('dropdownlist',[139,133,249,153], fpsliststr); 
win.fpsddl.justify    = 'center';
win.fpsddl.selection  = 5;


// ------------ the fill color settings UI ------------
win.colorpicker = win.colorspanel.add('dropdownlist', [  9,  8,249, 30], colorslist); 
win.colorpicker.add ("separator", undefined, 9);
win.colorpicker.add ("separator", undefined, 16);
win.colorpicker.add ("separator", undefined, 19);


win.hslrangelabel = win.colorspanel.add('statictext', [  9, 37, 79, 58], 'Range in \u00B0: ----------'); 
win.hslrangeval = win.colorspanel.add('edittext',     [ 79, 37,119, 59], String(RANGE)); 
win.roffsetlabel = win.colorspanel.add('statictext',  [139, 37,209, 57], 'Offset in \u00B0: ----------'); 
win.roffsetval = win.colorspanel.add('edittext',      [209, 37,249, 59], String(ROFFSET)); 
win.satlabel = win.colorspanel.add('statictext',      [  9, 68, 79, 88], 'Sat in %: ----------'); 
win.satval = win.colorspanel.add('edittext',          [ 79, 67,119, 89], String(SATURATION)); 
win.lghtlabel = win.colorspanel.add('statictext',     [139, 67,209, 87], 'Light in %: ----------');
win.lghtnval = win.colorspanel.add('edittext',        [209, 67,249, 89], String(LIGHTNESS)); 



// for custom colors. it came to me in a dream
win.redlabel = win.colorspanel.add('statictext',      [  9, 98, 79,119], 'R: ----------'); 
win.redval = win.colorspanel.add('edittext',          [ 79, 97,119,119], String(CCRGB.R)); 
win.greenlabel = win.colorspanel.add('statictext',    [  9,128, 79,149], 'G: ----------'); 
win.greenval = win.colorspanel.add('edittext',        [ 79,127,119,149],  String(CCRGB.G));
win.bluelabel = win.colorspanel.add('statictext',     [  9,158, 79,179], 'B: ----------'); 
win.blueval = win.colorspanel.add('edittext',         [ 79,157,119,179],  String(CCRGB.B)); 

win.huecclabel = win.colorspanel.add('statictext',    [139, 98,209,119], 'H: ----------'); 
win.hueccval = win.colorspanel.add('edittext',        [209, 97,249,119],  String(CCHSL.H)); 
win.satcclabel = win.colorspanel.add('statictext',    [139,128,209,149], 'S: ----------'); 
win.satccval = win.colorspanel.add('edittext',        [209,127,249,149], String(CCHSL.S));
win.lightcclabel = win.colorspanel.add('statictext',  [139,158,209,179], 'L: ----------'); 
win.lightccval = win.colorspanel.add('edittext',      [209,157,249,179], String(CCHSL.L)); 

// ------------ the contour color settings ------------

win.contourcolorpicker = win.contourpanel.add('dropdownlist', [  9,  8,249, 30], contourcolorslist);
win.contourcolorpicker.add ("separator", undefined, 9);

win.c_redlabel = win.contourpanel.add('statictext',      [  9, 37, 79, 58], 'R: ----------'); 
win.c_redval = win.contourpanel.add('edittext',          [ 79, 37,119, 59], String(CCCRGB.R)); 
win.c_greenlabel = win.contourpanel.add('statictext',    [  9, 68, 79, 88], 'G: ----------'); 
win.c_greenval = win.contourpanel.add('edittext',        [ 79, 67,119, 89],  String(CCCRGB.G));
win.c_bluelabel = win.contourpanel.add('statictext',     [  9, 98, 79,119], 'B: ----------'); 
win.c_blueval = win.contourpanel.add('edittext',         [ 79, 97,119,119],  String(CCCRGB.B)); 
win.c_huecclabel = win.contourpanel.add('statictext',    [139, 37,209, 57], 'H: ----------'); 
win.c_hueccval = win.contourpanel.add('edittext',        [209, 37,249, 59],  String(CCCHSL.H)); 
win.c_satcclabel = win.contourpanel.add('statictext',    [139, 67,209, 87], 'S: ----------'); 
win.c_satccval = win.contourpanel.add('edittext',        [209, 67,249, 89], String(CCCHSL.S));
win.c_lightcclabel = win.contourpanel.add('statictext',  [139, 98,209,119], 'L: ----------'); 
win.c_lightccval = win.contourpanel.add('edittext',      [209, 97,249,119], String(CCCHSL.L)); 


// ------------ Lots of UI properties ------------
win.selector.helpTip =             TIPSelector;
win.colorpicker.selection = 0; // thats BLACK
win.colorspanel.enabled = false;

win.contourcolorpicker.selection = 1; // thats white
win.contourpanel.enabled = false;
win.versionlabel.justify          = 'right';



win.roffsetval.enabled            = false;
win.roffsetlabel.enabled          = false;
win.hslrangeval.enabled           = false;
win.hslrangelabel.enabled         = false;
win.lghtnval.enabled              = false;
win.lghtlabel.enabled             = false;
win.satval.enabled                = false;
win.satlabel.enabled              = false;

// ------------ this is fill color selection ------------
win.redlabel.enabled              = false;
win.redval.enabled                = false;
win.greenlabel.enabled            = false;
win.greenval.enabled              = false;
win.bluelabel.enabled             = false;
win.blueval.enabled               = false;
win.huecclabel.enabled            = false;
win.hueccval.enabled              = false;
win.satcclabel.enabled            = false;
win.satccval.enabled              = false;
win.lightcclabel.enabled          = false;
win.lightccval.enabled            = false;

win.redlabel.helpTip              = TIPRed;
win.redval.helpTip                = TIPRed;
win.greenlabel.helpTip            = TIPGreen;
win.greenval.helpTip              = TIPGreen;
win.bluelabel.helpTip             = TIPBlue;
win.blueval.helpTip               = TIPBlue;
win.huecclabel.helpTip            = TIPCCHue;
win.hueccval.helpTip              = TIPCCHue;
win.satcclabel.helpTip            = TIPCCSat
win.satccval.helpTip              = TIPCCSat;
win.lightcclabel.helpTip          = TIPCClight;
win.lightccval.helpTip            = TIPCClight;

win.roffsetval.helpTip            = TIProffset;
win.roffsetlabel.helpTip          = TIProffset;
win.hslrangeval.helpTip           = TIPrange;
win.hslrangelabel.visible         = TIPrange;
win.lghtnval.helpTip              = TIPlght;
win.lghtlabel.helpTip             = TIPlght;
win.satval.helpTip                = TIPsat;
win.satlabel.helpTip              = TIPsat;
win.colorpicker.helpTip           = TIPcpick;
win.durval.helpTip                = TIPdur;
win.durlabel.helpTip              = TIPdur;
win.fpsddl.helpTip                = TIPfpsddl;

// ------------ this is contour color selection ------------
win.c_redlabel.enabled            = false;
win.c_redval.enabled              = false;
win.c_greenlabel.enabled          = false;
win.c_greenval.enabled            = false;
win.c_bluelabel.enabled           = false;
win.c_blueval.enabled             = false;
win.c_huecclabel.enabled          = false;
win.c_hueccval.enabled            = false;
win.c_satcclabel.enabled          = false;
win.c_satccval.enabled            = false;
win.c_lightcclabel.enabled        = false;
win.c_lightccval.enabled          = false;


win.c_redlabel.helpTip             =  TIPRed;
win.c_redval.helpTip                = TIPRed;
win.c_greenlabel.helpTip            = TIPGreen;
win.c_greenval.helpTip              = TIPGreen;
win.c_bluelabel.helpTip             = TIPBlue;
win.c_blueval.helpTip               = TIPBlue;
win.c_huecclabel.helpTip            = TIPCCHue;
win.c_hueccval.helpTip              = TIPCCHue;
win.c_satcclabel.helpTip            = TIPCCSat
win.c_satccval.helpTip              = TIPCCSat;
win.c_lightcclabel.helpTip          = TIPCClight;
win.c_lightccval.helpTip            = TIPCClight;  

// win.hslrangeval.justify           = 'left'; 
// win.hslrangelabel.justify         = 'left'; 
// win.roffsetval.justify            = 'left'; 
// win.roffsetlabel.justify          = 'left'; 
// win.satval.justify                = 'left'; 
// win.satlabel.justify              = 'left'; 
// win.lghtnval.justify              = 'left'; 
// win.lghtlabel.justify             = 'left';


// ------------ these are the compsettings ------------

win.threedee.value                = THREEDEE; 
win.tmstmp.value                  = TIMESTAMP; 
win.zorro.value                   = ZORRO; 
win.zorro.enabled                 = false;
win.addstroke.value               = STROKE; 
win.prcmpchbx.value               = PRECOMPOSE;
win.prcmpchbx.enabled             = false;
win.singlechbx.value              = SINGLELAYER;
win.useshapelayers.value          = USESHAPELAYERS;
win.reposanchorcheckbox.value     = REPOSANCHORBOOL;
win.reposanchorcheckbox.enabled   = false;
win.linkcheckbox.value            = LINKBOOL;
win.linkcheckbox.enabled          = false;

win.threedee.helpTip              = TIP3d; 
win.tmstmp.helpTip                = TIPtmstmp; 
win.zorro.helpTip                 = TIPzorro; 
win.addstroke.helpTip             = TIPstroke; 
win.prcmpchbx.helpTip             = TIPprcmp;
win.singlechbx.helpTip            = TIPsinglelyr;
win.useshapelayers.helpTip        = TIPuseshapelayers;
win.compname.helpTip              = TIPcmpnm;
win.compnamelabel.helpTip         = TIPcmpnm;
win.scalefacval.helpTip           = TIPscale;
win.scalefaclabel.helpTip         = TIPscale;
win.reposanchorcheckbox.helpTip   = TIPRepositionanchors;
win.linkcheckbox.helpTip          = TIPlinkcheckbox;

win.scalefacval.justify           = 'center'; 
win.scalefaclabel.justify         = 'center'; 
win.compname.justify              = 'center'; 
win.compnamelabel.justify         = 'center'; 
win.durlabel.justify              = 'center'; 
win.durval.justify                = 'center'; 



// ------------ the functions for the checkboxes ------------
win.threedee.onClick  = function (){THREEDEE = this.value;}; // 3D Cehckbox
win.tmstmp.onClick    = function (){TIMESTAMP = this.value; win.compname.notify()};// Timestamp checkbox
win.zorro.onClick     = function (){ZORRO = this.value;}; // zorro checkbox
win.linkcheckbox.onClick = function(){LINKBOOL = this.value}; // the link checkbox
win.reposanchorcheckbox.onClick = function(){REPOSANCHORBOOL = this.value};

win.addstroke.onClick = function (){ // stroke checkbox
    STROKE = this.value;
    // we set the timestamp if we use the stroke option
    // the user can reset it but it is safer this way for the expression linking
    if(this.value == true && (win.singlechbx.value == false)){
      win.contourpanel.enabled = true;
      win.contourcolorpicker.selection = 1;
      win.contourcolorpicker.notify();

        TIMESTAMP = true;
        win.tmstmp.value = true;
        LINKBOOL = true;
        win.linkcheckbox.enabled = true;
        win.linkcheckbox.value = true;
        }else if((this.value == true)&&(win.singlechbx.value == true)){
        LINKBOOL = false;
        win.linkcheckbox.value = false;
      };

    if(!this.value){
      win.linkcheckbox.value = false;
      win.linkcheckbox.enabled = false;
      win.contourpanel.enabled = false;
      };
};


win.prcmpchbx.onClick = function (){PRECOMPOSE = this.value;};// precomp checkbox

 // ------------ the shape layer option ------------
win.useshapelayers.onClick = function (){
          USESHAPELAYERS = this.value;
          if(this.value == true){
            win.addstroke.text = UIsettingsStrings.addstroke[1]; 
            }else{
            win.addstroke.text = UIsettingsStrings.addstroke[0];
            }; 
          };// end the use shape layers checkbox

 // ------------------------


 // ------------ the single layer option ------------
win.singlechbx.onClick = function (){
    SINGLELAYER = this.value;

    if(this.value == true){
        win.zorro.value = false;
        ZORRO = false;
        win.zorro.enabled = false;

        win.prcmpchbx.value = false;
        PRECOMPOSE = false;
        win.prcmpchbx.enabled = false;
        win.linkcheckbox.value = false;
        LINKBOOL = false;
        win.linkcheckbox.enabled = false;
        win.reposanchorcheckbox.value = false;
        REPOSANCHORBOOL = false;
        win.reposanchorcheckbox.enabled = false;
        win.colorpicker.selection = 0; // thats BLACK
        win.contourcolorpicker.selection = 1;// this is WHITE
        SELECTEDCONTOURCOLOR = WHITE;
        SELECTEDCOLOR = BLACK;
        win.contourpanel.enabled = false;
        win.colorspanel.enabled = false;


    }else if(!this.value){
        win.prcmpchbx.enabled = true;
        win.zorro.enabled = true;
        SINGLELAYER = false;
        win.colorspanel.enabled = true;
        win.colorpicker.selection = 0; // thats BLACK
        win.colorpicker.notify();
        win.reposanchorcheckbox.enabled = true;
        win.reposanchorcheckbox.value = true;
        REPOSANCHORBOOL = true;


        if(win.addstroke.value == true ){
            win.linkcheckbox.enabled = true;
            win.linkcheckbox.value = true;
            LINKBOOL = true;
            win.tmstmp.value = true;
            TIMESTAMP = true;
            win.contourpanel.enabled = true;
            win.contourcolorpicker.selection = 1;// this is WHITE
            win.contourcolorpicker.notify();
          };
        // win.linkcheckbox.enabled = true;
    };
};// end single layer checkbox

// ------------ THESE ARE THE TEXTFIELDS ------------

// ------------ the comp name edittext ------------
win.compname.onChange = function (){
    COMPNAME  = this.text;
    COMPNAME = shortenName(COMPNAME);

    if(COMPNAME.length == 0){
      COMPNAME = "brave new world map";
      this.text = "brave new world map";
      alert(ERRORname + COMPNAME);
    };

  if((this.text.length > 13) && (parseFloat(app.version) < 10.0) && (TIMESTAMP == true)){
      COMPNAME = this.text.substring(0,13);
      alert(ERRORcs4longnametmsp.alertString(COMPNAME));
      this.text = COMPNAME;
    };
  
  if((this.text.length > 27) && (parseFloat(app.version) < 10.0) && (TIMESTAMP == false)) {
      COMPNAME = this.text.substring(0,27);
      alert(ERRORcs4longcompname.alertString(COMPNAME));
      this.text = COMPNAME;     
    };
};

// ------------ FPS DDL ------------
win.fpsddl.onChange = function (){

for(var i in fpslist){
          if(this.selection == i){
        FPS = fpslist[i];
        };
      };
      // if(DEBUG) alert(FPS);
};

// ------------ the scale textfield ------------
win.scalefacval.onChange = function (){

        SCALE = resetValIfNAN(Math.abs(parseFloat (this.text)),1,ERRORscale + SCALE);

        if(SCALE < 0.1){
            SCALE = 0.1;
            this.text = SCALE;
            alert(ERROR2small + SCALE)}
        if(SCALE > 80){
            SCALE = 80;
             this.text = SCALE;
            alert(ERROR2big + SCALE);
          };

        if((checkFloat(SCALE) == true)&&(checkFloat(SCALE*360))&&(checkFloat(SCALE*180))){

          alert(ERRORscaleNotInt + " w:" +String(SCALE*360) + " h: "+String(SCALE*180) );

        };  
  }; // end of scalefacval


  // ------------ the duration textfield ------------
win.durval.onChange = function (){

        DUR = resetValIfNAN(Math.abs(parseFloat (this.text)), 23, ERRORdur + DUR);

        if(DUR < 0.1){
            DUR         = 0.1;
            this.text   = DUR;
            alert(ERROR2short + DUR)
        };
        if(DUR > 10800){
            DUR         = 10800;
             this.text  = DUR;
            alert(ERROR2long + DUR)};
        };

    // ------------ the range offset ------------
win.roffsetval.onChange = function (){
  ROFFSET = resetValIfNAN( Math.abs(parseInt (this.text)) ,0, ERRORrof + 0);
  this.text = ROFFSET;
  };

// ------------ the range ------------
win.hslrangeval.onChange = function (){
  RANGE = resetValIfNAN( Math.abs(parseInt (this.text)) ,0, ERRORrof + 0);
  this.text = RANGE;
    };

// ------------ the saturation ------------
win.satval.onChange = function (){
    SATURATION  = constrainAndParseTextToInteger(this.text, ERRORsat + String(55), 0, 100, 55);
    this.text = SATURATION;
    };

// ------------ the lightness ------------
win.lghtnval.onChange = function (){
    LIGHTNESS = constrainAndParseTextToInteger(this.text, ERRORlghtn + String(66), 0, 100, 66);
    this.text = LIGHTNESS;

    };

  //   _____ _    _  _____ _______ ____  __  __    _____ ____  _      ____  _____   _____ 
  //  / ____| |  | |/ ____|__   __/ __ \|  \/  |  / ____/ __ \| |    / __ \|  __ \ / ____|
  // | |    | |  | | (___    | | | |  | | \  / | | |   | |  | | |   | |  | | |__) | (___  
  // | |    | |  | |\___ \   | | | |  | | |\/| | | |   | |  | | |   | |  | |  _  / \___ \ 
  // | |____| |__| |____) |  | | | |__| | |  | | | |___| |__| | |___| |__| | | \ \ ____) |
  //  \_____|\____/|_____/   |_|  \____/|_|  |_|  \_____\____/|______\____/|_|  \_\_____/ 
                                                                                       
                                                                                       
win.redval.onChange = function () {

    CCRGB.R = constrainAndParseColorValue(this.text, ERRORcccolorsettoNAN.alertString("RED",255), 0, 255);
    this.text = CCRGB.R;
    if (DEBUG)alert(CCRGB.getVal());
    };

win.greenval.onChange = function () {
    CCRGB.G = constrainAndParseColorValue(this.text,ERRORcccolorsettoNAN.alertString("GREEN",255), 0, 255);
    this.text = CCRGB.G;
    if (DEBUG)alert(CCRGB.getVal());
    };

win.blueval.onChange = function () {
    CCRGB.B = constrainAndParseColorValue(this.text,ERRORcccolorsettoNAN.alertString("BLUE",255),0,255);
    this.text = CCRGB.B;
    if (DEBUG)alert(CCRGB.getVal());
    };

// ------------ this is HSL custom fill color ------------
win.hueccval.onChange = function () {
    CCHSL.H = constrainAndParseColorValue(this.text,ERRORcccolorsettoNAN.alertString("HUE",360),0,360 );
    this.text = CCHSL.H;
    if (DEBUG)alert(CCHSL.getVal());
    };

win.satccval.onChange = function () {
    CCHSL.S = constrainAndParseColorValue(this.text, ERRORcccolorsettoNAN.alertString("SATURATION",100),0,100);
    this.text = CCHSL.S;
    if (DEBUG)alert(CCHSL.getVal());
    };

win.lightccval.onChange = function () {
    CCHSL.L = constrainAndParseColorValue(this.text,ERRORcccolorsettoNAN.alertString("LIGHTNESS",100),0,100);
    this.text = CCHSL.L;
    if (DEBUG)alert(CCHSL.getVal());
    };

  //  _______ _    _ ______    _____ _    _  _____ _______ ____  __  __ 
  // |__   __| |  | |  ____|  / ____| |  | |/ ____|__   __/ __ \|  \/  |
  //    | |  | |__| | |__    | |    | |  | | (___    | | | |  | | \  / |
  //    | |  |  __  |  __|   | |    | |  | |\___ \   | | | |  | | |\/| |
  //    | |  | |  | | |____  | |____| |__| |____) |  | | | |__| | |  | |
  //    |_|  |_|  |_|______|  \_____|\____/|_____/   |_|  \____/|_|  |_|
                                                                     
                                                                     
  //   _____ ____  _   _ _______ ____  _    _ _____     _____ ____  _      ____  _____  
  //  / ____/ __ \| \ | |__   __/ __ \| |  | |  __ \   / ____/ __ \| |    / __ \|  __ \ 
  // | |   | |  | |  \| |  | | | |  | | |  | | |__) | | |   | |  | | |   | |  | | |__) |
  // | |   | |  | | . ` |  | | | |  | | |  | |  _  /  | |   | |  | | |   | |  | |  _  / 
  // | |___| |__| | |\  |  | | | |__| | |__| | | \ \  | |___| |__| | |___| |__| | | \ \ 
  //  \_____\____/|_| \_|  |_|  \____/ \____/|_|  \_\  \_____\____/|______\____/|_|  \_\
                                                                                     

win.c_redval.onChange = function () {
    CCCRGB.R = constrainAndParseColorValue(this.text, ERRORcccolorsettoNAN.alertString("RED",255), 0, 255);
    this.text = CCCRGB.R;
    if (DEBUG)alert(CCCRGB.getVal());
    };

win.c_greenval.onChange = function () {
    CCCRGB.G = constrainAndParseColorValue(this.text,ERRORcccolorsettoNAN.alertString("GREEN",255), 0, 255);
    this.text = CCCRGB.G;
    if (DEBUG)alert(CCCRGB.getVal());
    };

win.c_blueval.onChange = function () {
    CCCRGB.B = constrainAndParseColorValue(this.text,ERRORcccolorsettoNAN.alertString("BLUE",255),0,255);
    this.text = CCCRGB.B;
    if (DEBUG)alert(CCCRGB.getVal());
    };

// ------------ this is HSL custom fill color ------------
win.c_hueccval.onChange = function () {
    CCCHSL.H = constrainAndParseColorValue(this.text,ERRORcccolorsettoNAN.alertString("HUE",360),0,360 );
    this.text = CCCHSL.H;
    if (DEBUG)alert(CCCHSL.getVal());
    };

win.c_satccval.onChange = function () {
    CCCHSL.S = constrainAndParseColorValue(this.text,ERRORcccolorsettoNAN.alertString("SATURATION",100),0,100);
    this.text = CCCHSL.S;
    if (DEBUG)alert(CCCHSL.getVal());
    };

win.c_lightccval.onChange = function () {
    CCCHSL.L  = constrainAndParseColorValue(this.text,ERRORcccolorsettoNAN.alertString("LIGHTNESS",100),0,100);
    this.text = CCCHSL.L;
    if (DEBUG)alert(CCCHSL.getVal());
    };


  //   _____ ____  _      ____  _____  _____ _____ _____ _  ________ _____  
  //  / ____/ __ \| |    / __ \|  __ \|  __ \_   _/ ____| |/ /  ____|  __ \ 
  // | |   | |  | | |   | |  | | |__) | |__) || || |    | ' /| |__  | |__) |
  // | |   | |  | | |   | |  | |  _  /|  ___/ | || |    |  < |  __| |  _  / 
  // | |___| |__| | |___| |__| | | \ \| |    _| || |____| . \| |____| | \ \ 
  //  \_____\____/|______\____/|_|  \_\_|   |_____\_____|_|\_\______|_|  \_\
                                                                         
                                                                         

// ------------ the dropdown list for the colors ------------
win.colorpicker.onChange = function (){
    
      if(this.selection == 0){SELECTEDCOLOR = BLACK;};
      if(this.selection == 1){SELECTEDCOLOR = WHITE;};
      if(this.selection == 2){SELECTEDCOLOR = GREY;};
      if(this.selection == 3){SELECTEDCOLOR = LIGHTGREY;};
      if(this.selection == 4){SELECTEDCOLOR = DARKGREY;};
      if(this.selection == 5){SELECTEDCOLOR = RED;};   
      if(this.selection == 6){SELECTEDCOLOR = GREEN;};
      if(this.selection == 7){SELECTEDCOLOR = BLUE;};    
      if(this.selection == 8){SELECTEDCOLOR = GUAVE;};
      // ------------ here comes a separator ------------
      if(this.selection == 10){
        SELECTEDCOLOR = BLACK;
        RANDOMCOLORS = true;
        HSLCOLORS = false;
        };

    if(this.selection == 11){
        HSLCOLORS = true;
        RANDOMCOLORS = false;
        SELECTEDCOLOR = BLACK;
        win.roffsetval.enabled = true;
        win.roffsetlabel.enabled = true;
        win.hslrangeval.enabled = true;
        win.hslrangelabel.enabled = true;
        win.lghtnval.enabled = true;
        win.lghtlabel.enabled = true;
        win.satval.enabled = true;
        win.satlabel.enabled = true; 
    }else{
        HSLCOLORS = false;
        win.roffsetval.enabled = false;
        win.roffsetlabel.enabled = false;
        win.hslrangeval.enabled = false;
        win.hslrangelabel.enabled = false;
        win.lghtnval.enabled = false;
        win.lghtlabel.enabled = false;
        win.satval.enabled = false;
        win.satlabel.enabled = false;
        };

          //   ________  __________  ______________
          //  /_  __/ / / / ____/  |/  / ____/ ___/
          //   / / / /_/ / __/ / /|_/ / __/  \__ \ 
          //  / / / __  / /___/ /  / / /___ ___/ / 
          // /_/ /_/ /_/_____/_/  /_/_____//____/  
                                                
        // ------------ lilac to red ------------
        if(this.selection == 12){ setTheme(BLACK , true, false,  80,45, 300, 60); this.selection = 11; };  
        // ------------ paleish greenish - sick ocean ------------
        if(this.selection == 13){ setTheme(BLACK , true, false,  23,66, 120, 30); this.selection = 11; };   
        // ------------ strong blue - wide ------------
        if(this.selection == 14){ setTheme(BLACK , true, false,  90,45, 200, 45); this.selection = 11; };   
        // ------------ strong red yellow green - pastafari baby! ------------
        if(this.selection == 15){ setTheme(BLACK , true, false,  90,45, 0, 120); this.selection = 11; }; 
   

 // ------------ this is HSL CC ------------       
  if(this.selection == 17){

        HSLCOLORS = false;
        RANDOMCOLORS = false;
        CCRGBBool = false;
        CCHSLBool = true;
        win.huecclabel.enabled               = true;
        win.hueccval.enabled                 = true;
        win.satcclabel.enabled               = true;
        win.satccval.enabled                 = true;
        win.lightcclabel.enabled             = true;
        win.lightccval.enabled               = true;

     if((win.colorspanel.visible == false) && (win.selector.selection == 0) ){   
        win.selector.selection = 1;
        win.selector.notify();

      };
        }else{

        win.huecclabel.enabled                = false;
        win.hueccval.enabled                  = false;
        win.satcclabel.enabled                = false;
        win.satccval.enabled                  = false;
        win.lightcclabel.enabled              = false;
        win.lightccval.enabled                = false;

        };

 // ------------ this is RGB CC ------------
  if(this.selection == 18){
    HSLCOLORS                         = false;
    RANDOMCOLORS                      = false;
    CCRGBBool                         = true;
    CCHSLBool                         = false;
    win.redlabel.enabled              = true;
    win.redval.enabled                = true;
    win.greenlabel.enabled            = true;
    win.greenval.enabled              = true;
    win.bluelabel.enabled             = true;
    win.blueval.enabled               = true;

      if((win.colorspanel.visible == false) && (win.selector.selection == 0) ){   
            win.selector.selection = 1;
            win.selector.notify();
          };
  }else{
    win.redlabel.enabled              = false;
    win.redval.enabled                = false;
    win.greenlabel.enabled            = false;
    win.greenval.enabled              = false;
    win.bluelabel.enabled             = false;
    win.blueval.enabled               = false;
    };


  if(this.selection == 20){
    NOFILLBOOL = true;
    if(win.useshapelayers.value == false){
      alert(ERRRORnofillwithsolids)
      this.selection = 0;
    };
  }else{
    NOFILLBOOL = false;
  };

function setTheme(selCol , hslbool, randomBool,  satVal,lightVal, rangeOffsetVal, rangeVal){

        SELECTEDCOLOR = selCol;
        HSLCOLORS = hslbool;
        RANDOMCOLORS = randomBool;
        win.satval.text = String(satVal);
        win.satval.notify();
        SATURATION = satVal;
        win.lghtnval.text = String(lightVal);
        win.lghtnval.notify();
        LIGHTNESS = lightVal;
        win.roffsetval.text = String(rangeOffsetVal);
        win.roffsetval.notify();
        ROFFSET = rangeOffsetVal;
        win.hslrangeval.text = String(rangeVal);
        win.hslrangeval.notify();
        RANGE = rangeVal;

  };
};

  //   _____ ____  _   _ _______ ____  _    _ _____    _____ _____ _____ _  ________ _____  
  //  / ____/ __ \| \ | |__   __/ __ \| |  | |  __ \  |  __ \_   _/ ____| |/ /  ____|  __ \ 
  // | |   | |  | |  \| |  | | | |  | | |  | | |__) | | |__) || || |    | ' /| |__  | |__) |
  // | |   | |  | | . ` |  | | | |  | | |  | |  _  /  |  ___/ | || |    |  < |  __| |  _  / 
  // | |___| |__| | |\  |  | | | |__| | |__| | | \ \  | |    _| || |____| . \| |____| | \ \ 
  //  \_____\____/|_| \_|  |_|  \____/ \____/|_|  \_\ |_|   |_____\_____|_|\_\______|_|  \_\
                                                                                         
                                                                                         


// ------------ the dropdown list for the colors ------------
win.contourcolorpicker.onChange = function (){
    
        if(this.selection == 0){SELECTEDCONTOURCOLOR = BLACK;};
        if(this.selection == 1){SELECTEDCONTOURCOLOR = WHITE;};
        if(this.selection == 2){SELECTEDCONTOURCOLOR = GREY; };
        if(this.selection == 3){SELECTEDCONTOURCOLOR = LIGHTGREY;};
        if(this.selection == 4){SELECTEDCONTOURCOLOR = DARKGREY;};
        if(this.selection == 5){SELECTEDCONTOURCOLOR = RED;};   
        if(this.selection == 6){SELECTEDCONTOURCOLOR = GREEN;};    
        if(this.selection == 7){SELECTEDCONTOURCOLOR = BLUE;};    
        if(this.selection == 8){SELECTEDCONTOURCOLOR = GUAVE;};
   // this is HSL CC

  if(this.selection == 10){
    CCCRGBBool = false;
    CCCHSLBool = true;
    win.c_huecclabel.enabled               = true;
    win.c_hueccval.enabled                 = true;
    win.c_satcclabel.enabled               = true;
    win.c_satccval.enabled                 = true;
    win.c_lightcclabel.enabled             = true;
    win.c_lightccval.enabled               = true;

     if((win.contourpanel.visible == false) && (win.selector.selection == 0) ){   
        win.selector.selection = 2;
        win.selector.notify();
      };
  }else{

    win.c_huecclabel.enabled                = false;
    win.c_hueccval.enabled                  = false;
    win.c_satcclabel.enabled                = false;
    win.c_satccval.enabled                  = false;
    win.c_lightcclabel.enabled              = false;
    win.c_lightccval.enabled                = false;

  };

        // this is RGB CC
         
  if(this.selection == 11){

      CCCRGBBool = true;
      CCCHSLBool = false;
      win.c_redlabel.enabled              = true;
      win.c_redval.enabled                = true;
      win.c_greenlabel.enabled            = true;
      win.c_greenval.enabled              = true;
      win.c_bluelabel.enabled             = true;
      win.c_blueval.enabled               = true;

    if((win.contourpanel.visible == false) && (win.selector.selection == 0) ){   
        win.selector.selection = 2;
        win.selector.notify();
      };
    }else{
    win.c_redlabel.enabled              = false;
    win.c_redval.enabled                = false;
    win.c_greenlabel.enabled            = false;
    win.c_greenval.enabled              = false;
    win.c_bluelabel.enabled             = false;
    win.c_blueval.enabled               = false
  };

};

  //  _______ _    _ ______    _____ _      ____  ____          _        ____  _    _ _______ _______ ____  _   _  _____ 
  // |__   __| |  | |  ____|  / ____| |    / __ \|  _ \   /\   | |      |  _ \| |  | |__   __|__   __/ __ \| \ | |/ ____|
  //    | |  | |__| | |__    | |  __| |   | |  | | |_) | /  \  | |      | |_) | |  | |  | |     | | | |  | |  \| | (___  
  //    | |  |  __  |  __|   | | |_ | |   | |  | |  _ < / /\ \ | |      |  _ <| |  | |  | |     | | | |  | | . ` |\___ \ 
  //    | |  | |  | | |____  | |__| | |___| |__| | |_) / ____ \| |____  | |_) | |__| |  | |     | | | |__| | |\  |____) |
  //    |_|  |_|  |_|______|  \_____|______\____/|____/_/    \_\______| |____/ \____/   |_|     |_|  \____/|_| \_|_____/ 
                                                                                                                      
                                                                                                                      
// ------------ the help button ------------
win.help.onClick = function () {
    alert(HELPTEXT);
    openURL(WEBSITE,winBrowserCmd,macBrowserCmdStart,macBrowserCmdEnd);
};

// ------------ the draw the map button ------------
win.drawmap.onClick = function () {    
    prepare_the_map(
    DEBUG,
    USESHAPELAYERS,
    THESELECTEDFILENAME,
    COMPNAME,
    ZORRO, 
    STROKE , 
    RANDOMCOLORS,
    THREEDEE,
    SCALE, 
    RANGE, 
    SATURATION ,
    LIGHTNESS,
    ROFFSET,
    HSLCOLORS,
    SELECTEDCOLOR,
    SELECTEDCONTOURCOLOR,
    TIMESTAMP,
    DUR,
    FPS,
    PRECOMPOSE,
    SINGLELAYER,
    CCRGBBool,
    CCHSLBool,
    CCCRGBBool,
    CCCHSLBool,
    CCRGB,
    CCHSL,
    CCCRGB,
    CCCHSL,
    CONTOURLIKEFILLBOOL,
    LINKBOOL,
    REPOSANCHORBOOL,
    NOFILLBOOL);

    };

		     
  }; 
return win 
};


  //  _    _ _______ _____ _      _____ _______ _____ ______  _____ 
  // | |  | |__   __|_   _| |    |_   _|__   __|_   _|  ____|/ ____|
  // | |  | |  | |    | | | |      | |    | |    | | | |__  | (___  
  // | |  | |  | |    | | | |      | |    | |    | | |  __|  \___ \ 
  // | |__| |  | |   _| |_| |____ _| |_   | |   _| |_| |____ ____) |
  //  \____/   |_|  |_____|______|_____|  |_|  |_____|______|_____/ 
                                                                 
                                                                 
// ------------ map functions ------------

function readinGeoJSONFile(THESELECTEDFILENAME){
        
  // var textFile = File.openDialog("Select a text file to import.", "*.*",false);
  var path = ((new File($.fileName)).path);
var textFile = File( path+"/world_geo_json/" + THESELECTEDFILENAME);

      if (textFile != null) {
        var textLines = new Array();
        textFile.open("r", "TEXT", "????");
        while (!textFile.eof){
                    textLines[textLines.length] = textFile.readln();  
                    }
                 textFile.close();   
                }
            if(!textLines){
                return;
                }
             var str = textLines.join("");       
            var reg = new RegExp("\n|\r","g");
            str.replace (reg, " ");
            var obj = eval("(" + str + ")"); // evaluate the JSON code
        return obj;       
        };

 // ------------ UI & DEBUG functions ------------

  function openURL(url,winBrowserCmd,macBrowserCmdStart,macBrowserCmdEnd){
    if ($.os.indexOf("Windows") != -1){
      system.callSystem("cmd /c \""+winBrowserCmd + "\" " + url);
    } else {
      system.callSystem(macBrowserCmdStart + url + macBrowserCmdEnd);
    };
  };


/**
 *  for cleaner code / constrains a value and checks for NAN (Not A Number)
 *
 */ 

function constrainAndParseColorValue(theText, theErrorMessage, minVal, maxVal){
  var val = parseInt (theText);
    if(val > maxVal){
        val = maxVal;
    };
    if(val < minVal){
        val = minVal;
    };
    val = resetValIfNAN(val, maxVal,theErrorMessage);

  return val;
};


function constrainAndParseTextToInteger(theText, theErrorMessage, minVal, maxVal,resetVal){
  var val = Math.abs( parseInt (theText));
    if(val > maxVal){
        val = maxVal;
    };
    if(val < minVal){
        val = minVal;
    };
    val = resetValIfNAN(val,resetVal,theErrorMessage);

  return val;
};

function resetValIfNAN(val,resetVal, theErrorMessage){
    if(isNaN (val)==true){
    val = resetVal;
    alert(theErrorMessage);
    };
  return val;
};


// if AE is version CS 4 this will shorten all names to 27 characters

function shortenName(str){
var res = "";
if(parseFloat(app.version) < 10.0){
  res = str.substr(0,26);
}else{
res = str;
};
  return res;
};

/**
 *  check float values
 *
 */ 

function checkFloat(val){
var res = false;
var nulled = val - Math.floor(val);
if(nulled != 0){
 res =  true;
}else{
res = false;

}; 

return res;
};


function CustomRGBColorObject (r,g,b){
this.R = r;
this.G = g;
this.B = b;
this.getVal = function(){
   return [this.R,this.B,this.B];
  };
this.setVal = function  (red,green,blue) {
  this.R = red;
  this.G = green;
  this.B = blue;
  };
};

function CustomHSLColorObject (h,s,l){
this.H = h;
this.S = s;
this.L = l;
this.getVal = function(){
   return [this.H,this.S,this.L];
  };
this.setVal = function  (hue,sat,light) {
  this.H = hue;
  this.S = sat;
  this.L = light;
  };
};


function createCustomHSLColor(customHSLobj, DEBUG){

var h = customHSLobj.H;
var s = customHSLobj.S;
var l = customHSLobj.L;


  var col = colors_builder(1, h, s, l ,0, 1);
  if(DEBUG)alert(col);
return col;
};

function createCustomRGBColor(customRGBobj,DEBUG){

var r = customRGBobj.R / 255;
var g = customRGBobj.G / 255;
var b = customRGBobj.B / 255;

  var col = [r,g,b];
  if(DEBUG) alert(col);
  return col;
};

/** 
 * The license dialoge
 * 
 */

function licenseDiag (n) {
    var lic= "DONT USE SCRIPTS FROM UNTRUSETED SOURCES! ALWAYS DOWNLOAD THIS SCRIPT @ AESCRIPTS.COM http://aescripts.com/aemap/\n\n"+
    "You have to allow the script to read and write to disk.\nso if you obtained this script from any other source then the above mentioned"+
"\nIT COULD INCLUDE MALICIOUS CODE!\nBy confirming this dialog you also accept the license agreement below\n"+    
"\nLICENSES\n"+"countries.geo.json and countries.zip and all its contents are UNLICENSED.\nSee also http://unlicense.org\n\n"+
"Copyright (c)  2012 Fabian \"fabiantheblind\" Morón Zirfas\n"+
"Permission is hereby granted, free of charge*, to any person obtaining a copy of this "+
"software and associated documentation files (the \"Software\"), to deal in the Software "+ 
"without restriction, including without limitation the rights to use, copy, modify "+ 
"the Software, and to permit persons to whom the Software is furnished to do so, subject to the following "+
"conditions:\n"+
"The above copyright notice and this permission notice shall be included in all copies "+ 
"or substantial portions of the Software.\n"+
"THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, "+ 
"INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A "+ 
"PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT "+ 
"HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF "+ 
"CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE "+
"OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n"+
"see also http://www.opensource.org/licenses/mit-license.php\n\n"+
"*if you want to donate something so I can buy cookies and beer\ndo it via aescripts.com\n";

var diag                = new Window ("dialog",n + " || readme and license agreement");
    diag.preferredSize  =    {"width":450,"height":450};
var pan                 = diag.add('group',undefined,'');
    pan.orientation     ='column';
var txt                 = pan.add('edittext',undefined,lic,{multiline:true,scrolling: false});
    txt.preferredSize   =    {"width":440,"height":430};
var btg                 =  pan.add ("group");
var cbg                 = btg.add ("group");
    cbg.alignment       = "left";
var cb                  = cbg.add ("checkbox", undefined, "dont warn me again");
    btg.orientation     = 'row';
    btg.alignment       = "right";
    btg.add ("button", undefined, "OK");
    btg.add ("button", undefined, "cancel");
if (diag.show () == 1){
    return [cb.value,true];
  }else{  
    return [false, false];
  };
};

  //  ______ _   _ _____  
  // |  ____| \ | |  __ \ 
  // | |__  |  \| | |  | |
  // |  __| | . ` | |  | |
  // | |____| |\  | |__| |
  // |______|_| \_|_____/ 
                       
                       

  //   ____  ______ 
  //  / __ \|  ____|
  // | |  | | |__   
  // | |  | |  __|  
  // | |__| | |     
  //  \____/|_|     
                 
                 

  //  _    _ _____ 
  // | |  | |_   _|
  // | |  | | | |  
  // | |  | | | |  
  // | |__| |_| |_ 
  //  \____/|_____|
                
// ------------------------------------------------------------------------------------------------
























// you could extract everything below this line to make it at oneshot script
// but who would?

// ---------------------------------------------------------------------

//~   _______ _    _ ______   __  __          _____  
//~  |__   __| |  | |  ____| |  \/  |   /\   |  __ \ 
//~     | |  | |__| | |__    | \  / |  /  \  | |__) |
//~     | |  |  __  |  __|   | |\/| | / /\ \ |  ___/ 
//~     | |  | |  | | |____  | |  | |/ ____ \| |     
//~     |_|  |_|  |_|______| |_|  |_/_/    \_\_|     
//~                                                

//--------------------------------------------------------------------------
//~  



function prepare_the_map(DEBUG, useshapelayers ,
  theselectedfilename ,
  compname,
  zorro, 
  addstroke,
  randomColors,
  threedee,
  factor,
  degrees, 
  s,
  l,
  offset,
  hslcolors,
  theColor,
  theContourColor,
  tmstmp,
  dur,
  fps,
  precompose,
  onto_singlelayer,
  CCRGBBool,
  CCHSLBool,
  CCCRGBBool,
  CCCHSLBool,
  CCRGB,
  CCHSL,
  CCCRGB,
  CCCHSL,
  contourLikeFill,
  linkBool,
  reposAnchorBool,
  noFillBool){
    

// ned to wrap all that settings into one nice JSON Object
// man i love JSON ;)
var allScriptSettings = {
  "GEOJSON"             : null,
  "DEBUG"               : DEBUG,
  "USESHAPELAYERS"      : useshapelayers, 
  "THESELECTEDFILENAME" : theselectedfilename,
  "COMPNAME"            : compname,
  "CURCOMP"             : null,
  "FULLNAME"            : null,
  "PROJECTFOLDER"       : null,
  "CONTROLLAYER"        : null,
  "THE_SINGLELAYER"     : null,
  "ZORRO"               : zorro,
  "ADDSTROKE"           : addstroke,
  "RANDOMCOLORS"        : randomColors,
  "THREEDEE"            : threedee,
  "DEGREES"             : degrees,
  "SATURATION"          : s,
  "LIGHTNESS"           : l,
  "OFFSET"              : offset,
  "HSLCOLORS"           : hslcolors,
  "THECOLOR"            : theColor,
  "THECONTOURCOLOR"     : theContourColor,
  "TIMESTAMPBOOL"       : tmstmp ,
  "TIMESTAMPVAL"        : null,
  "DURATION"            : dur,
  "FPS"                 : fps,
  "PRECOMPOSE"          : precompose,
  "ONTO_SINGLELAYER"    : onto_singlelayer,
  "LINKBOOL"            : linkBool,
  "REPOSANCHORBOOL"     : reposAnchorBool ,
  "CONTOURLIKEFILLBOOL" : contourLikeFill,
  "CCRGBBOOL"           : CCRGBBool,
  "CCRGB"               : CCRGB,
  "CCHSLBOOL"           : CCHSLBool,
  "CCHSL"               : CCHSL,
  "CCCRGBBOOL"          : CCCRGBBool,
  "CCCRGB"              : CCCRGB,
  "CCCHSLBOOL"          : CCCHSLBool,
  "CCCHSL"              : CCCHSL, 
  "STARTDATE"           : null,
  "ENDDATE"             : null,
  "SCALE"               : factor,
  "COMPWIDTH"           : null,
  "COMPHEIGHT"          : null,
  "CW"                  : 360,
  "CH"                  : 180,
  "LIST"                : [],
  "FEATURESLENGTH"      : null,
  "NUMOFPOLYGONS"       : 286,
  "NOFILLBOOL"          : noFillBool
  };

    allScriptSettings.STARTDATE = new Date(); // this is for time recording

    app.beginUndoGroup("build equirectangular map");
    allScriptSettings.COMPWIDTH = allScriptSettings.CW * allScriptSettings.SCALE;
    allScriptSettings.COMPHEIGHT = allScriptSettings.CH * allScriptSettings.SCALE;

// ------------ TIMESTAMP ------------
if(allScriptSettings.TIMESTAMPBOOL == true){
  allScriptSettings.TIMESTAMPVAL = Number(new Date());
  allScriptSettings.FULLNAME = allScriptSettings.COMPNAME+ "_"+allScriptSettings.TIMESTAMPVAL;
  }else{
  allScriptSettings.FULLNAME = allScriptSettings.COMPNAME;
  };

    // ------------ make the comp ------------
allScriptSettings.CURCOMP = app.project.items.addComp(
                                        shortenName (allScriptSettings.FULLNAME),
                                        Math.floor(allScriptSettings.CW * allScriptSettings.SCALE),
                                        Math.floor(allScriptSettings.CH *  allScriptSettings.SCALE),
                                        1,
                                        allScriptSettings.DURATION,
                                        allScriptSettings.FPS
                                        );
// allScriptSettings.CURCOMP = curComp;

if(allScriptSettings.PRECOMPOSE == true){
      allScriptSettings.PROJECTFOLDER = app.project.items.addFolder(shortenName( "GEOJson "+ allScriptSettings.FULLNAME));
  };

// ------------ reset view so we can see something ------------
// this is a workaround to make the created comp the frontmost comp
 // ae needs at least 2 frames for previewing
var duration = allScriptSettings.CURCOMP.workAreaDuration;
allScriptSettings.CURCOMP.workAreaDuration = (1/allScriptSettings.CURCOMP.frameRate)*5; 
allScriptSettings.CURCOMP.ramPreviewTest(1.0,1.0,0);// i think this is where the CS4 Problems start 
allScriptSettings.CURCOMP.workAreaDuration = duration;
allScriptSettings.CURCOMP.resolutionFactor = [4,4];


// ------------ Caculate the colors for the fill ------------

if(allScriptSettings.CCRGBBOOL == true){
var tempColrgb = createCustomRGBColor(
                      allScriptSettings.CCRGB,
                      allScriptSettings.DEBUG
                      );
  allScriptSettings.THECOLOR = tempColrgb;

} else if(allScriptSettings.CCHSLBOOL == true){
var tempColorhsl = createCustomHSLColor(
                      allScriptSettings.CCHSL,
                      allScriptSettings.DEBUG
                      );
allScriptSettings.THECOLOR = tempColorhsl;
};


// ------------ Calculate the colors for the contour ------------
if(allScriptSettings.CCCRGBBOOL == true){
var tempContourColorrgb = createCustomRGBColor(
                              allScriptSettings.CCCRGB,
                              allScriptSettings.DEBUG
                              );
  allScriptSettings.THECONTOURCOLOR = tempContourColorrgb;

}else if(allScriptSettings.CCCHSLBOOL == true){
var tempContourColorhsl = createCustomHSLColor(
                              allScriptSettings.CCCHSL,
                              allScriptSettings.DEBUG
                              );
allScriptSettings.THECONTOURCOLOR = tempContourColorhsl;
}; 

// end of color creation

// ------------ if add stroke is selected ------------
if(
  (allScriptSettings.ADDSTROKE == true )&&
  (allScriptSettings.ONTO_SINGLELAYER == false) && 
  (allScriptSettings.LINKBOOL==true)
  ){
    // add a null object with some expression controllers
allScriptSettings.CONTROLLAYER = addStrokeController(
                                    allScriptSettings.CURCOMP,
                                    allScriptSettings.ZORRO,
                                    allScriptSettings.USESHAPELAYERS,
                                    allScriptSettings.THECONTOURCOLOR
                                    );

};
// ------------ call the map drawing function ------------
// returns a list of used names and ids

allScriptSettings.GEOJSON = readinGeoJSONFile( allScriptSettings.THESELECTEDFILENAME );
allScriptSettings.FEATURESLENGTH = allScriptSettings.GEOJSON.features.length;



// ------------ this is for single layers ------------
if(allScriptSettings.ONTO_SINGLELAYER== true){
  if(allScriptSettings.USESHAPELAYERS == true){
      allScriptSettings.SINGLELAYER = allScriptSettings.CURCOMP.layers.addShape();
      allScriptSettings.SINGLELAYER.name = shortenName( "Solid_"+ allScriptSettings.CURCOMP.name);
      allScriptSettings.SINGLELAYER.duration = allScriptSettings.CURCOMP.duration;
      // allScriptSettings.SINGLELAYER.position.setValue([0,0]);
      allScriptSettings.SINGLELAYER.anchorPoint.setValue([allScriptSettings.CURCOMP.width/2,allScriptSettings.CURCOMP.height/2]);

    if(allScriptSettings.NOFILLBOOL!= true){    
        var fillProp = allScriptSettings.SINGLELAYER("ADBE Root Vectors Group").addProperty("ADBE Vector Graphic - Fill");
            fillProp.name = "fill";   
            fillProp.property("ADBE Vector Fill Color").setValue(allScriptSettings.THECOLOR);
    };
  }else if (allScriptSettings.USESHAPELAYERS == false){
      allScriptSettings.SINGLELAYER = allScriptSettings.CURCOMP.layers.addSolid(
                                      allScriptSettings.THECOLOR ,
                                      shortenName( "Solid_"+ allScriptSettings.CURCOMP.name) , 
                                      allScriptSettings.CURCOMP.width , 
                                      allScriptSettings.CURCOMP.height , 
                                      1, 
                                      allScriptSettings.CURCOMP.duration);
  }; // end of single layer shapelayers vs solids check 
};


// ------------ now move on to draw the map ------------
DRAWTHEMAP(allScriptSettings, DEBUG);

// now if we have a single shape layer we need to move the fill property to the end
if(
  (allScriptSettings.ONTO_SINGLELAYER   == true) &&
  (allScriptSettings.USESHAPELAYERS     == true) &&
  (allScriptSettings.NOFILLBOOL         != true)
  ){
      var thefillProp = allScriptSettings.SINGLELAYER("ADBE Root Vectors Group").property("fill");
      thefillProp.moveTo(allScriptSettings.NUMOFPOLYGONS + 1);
    };

app.endUndoGroup();


// ------------ the final alert ------------
allScriptSettings.ENDDATE = new Date();
var timeTaken = allScriptSettings.ENDDATE.getTime() - allScriptSettings.STARTDATE.getTime();
alert("main function end\nlogging of after: " + timeTaken/1000 + " seconds"); 
    
};



 //  _____  _____      __          __  _______ _    _ ______   __  __          _____  
 // |  __ \|  __ \    /\ \        / / |__   __| |  | |  ____| |  \/  |   /\   |  __ \ 
 // | |  | | |__) |  /  \ \  /\  / /     | |  | |__| | |__    | \  / |  /  \  | |__) |
 // | |  | |  _  /  / /\ \ \/  \/ /      | |  |  __  |  __|   | |\/| | / /\ \ |  ___/ 
 // | |__| | | \ \ / ____ \  /\  /       | |  | |  | | |____  | |  | |/ ____ \| |     
 // |_____/|_|  \_|_/    \_\/  \/        |_|  |_|  |_|______| |_|  |_/_/    \_\_|     
                                                                                   
                                                                                   
// with some hints from the fine jongware
// see http://forums.adobe.com/message/2538244#2538244
// draws the equirectangular map with some set arguments
function DRAWTHEMAP(allScriptSettings,DEBUG){

var theFolder         = allScriptSettings.PROJECTFOLDER;
var countrieControl   = allScriptSettings.CONTROLLAYER;
var scale             = allScriptSettings.SCALE;
var zorro             = allScriptSettings.ZORRO;
var addstroke         = allScriptSettings.ADDSTROKE;
var randomColors      = allScriptSettings.RANDOMCOLORS;
var threedee          = allScriptSettings.THREEDEE;
var degrees           = allScriptSettings.DEGREES;
var s                 = allScriptSettings.SATURATION;
var l                 = allScriptSettings.LIGHTNESS;
var offset            = allScriptSettings.OFFSET;
var hslcolors         = allScriptSettings.HSLCOLORS;
var precompose        = allScriptSettings.PRECOMPOSE;
var tmstmp            = allScriptSettings.TIMESTAMPBOOL;
var timestamp         = allScriptSettings.TIMESTAMPVAL;
var onto_singlelayer  = allScriptSettings.ONTO_SINGLELAYER;
var CCRGBBool         = allScriptSettings.CCRGBBOOL;
var CCHSLBool         = allScriptSettings.CCHSLBOOL;
var CCRGB             = allScriptSettings.CCRGB;
var CCHSL             = allScriptSettings.CCHSL;
var curComp           = allScriptSettings.CURCOMP;
var GEOJson           = allScriptSettings.GEOJSON;
var list              = new Array(); // this is the return value
// loop thur the GEOJson
  
for (var i = 0; i < GEOJson.features.length; i++) {
    
// ------------ this works out the hsl or random colors ------------
    if(allScriptSettings.HSLCOLORS == true){
    allScriptSettings.THECOLOR = colors_builder (GEOJson.features.length , degrees, s, l, offset, i);
    
    } else if (allScriptSettings.RANDOMCOLORS == true){

    allScriptSettings.THECOLOR = [Math.random(), Math.random(), Math.random()];
    }; // end random colors


      // for better handling
	   var cnt = GEOJson.features[i];
     var name = cnt.properties.name;
	   var type = cnt.geometry.type;
	   var coords = cnt.geometry.coordinates;
    
    // push data in to the list that gets returned
    // this is not realy used right know
    allScriptSettings.LIST.push({"name":name,"id":cnt.id,"type":type});


    writeLn("("+(i)+"/"+GEOJson.features.length +") "+name);
	// look for polygon or multipolygon
  // if it is multipolygon we have to dig deeper to get the 
    // vertecies values

	var pattern = "MultiPolygon";
	var reg = new RegExp(pattern,"g");
	if (reg.test(type) == true){
	
   if(precompose == true){
      var list_of_layers = new Array();
      };// for precomposing the GEOJson

	 for (var j = 0; j < coords.length; j++) {
		for (var k = 0; k < coords[j].length; k++) {
                // finally draw a layer with a polygon / and store it for precomping
              var layer =  drawPolygon(allScriptSettings, coords[j][k], cnt.id + "_"+ name ,String(j), i);
              if(
                (allScriptSettings.ONTO_SINGLELAYER == false)
                && (allScriptSettings.REPOSANCHORBOOL == true)
                ){
                repositionAnchor(layer);
              };
          if(precompose == true){
          list_of_layers.push(layer);
          };
		}; // close k loop
	}; // close j loop
    // now precompose all polygon objects from one countrie
    if(precompose == true){
        precomper (list_of_layers, curComp, theFolder, cnt.id + "_"+ name , name,zorro,threedee,tmstmp,timestamp);
      
      }; // close if precompose

	}else{
    // ------------ this only polygon not multipolygon ------------ 

	// we have only a polygon dont need the loop
        var layer = drawPolygon (allScriptSettings, coords[0], cnt.id + "_"+ name,"", i);
            if(
              (allScriptSettings.ONTO_SINGLELAYER == false)
              && (allScriptSettings.REPOSANCHORBOOL == true)
              ){
              repositionAnchor(layer);
            };
        if(precompose){
          var list_of_layers = new Array();
              list_of_layers.push(layer);
              precomper (list_of_layers, curComp, theFolder, cnt.id + "_"+ name , name, zorro,threedee,tmstmp,timestamp);

        }; // close precompose

	};// close else
}; // end of i loop over geojson.features
GEOJson = null; // Collect the Garbadge
// done
};






  //  _____   ____  _  __     _______  ____  _   _ 
  // |  __ \ / __ \| | \ \   / / ____|/ __ \| \ | |
  // | |__) | |  | | |  \ \_/ / |  __| |  | |  \| |
  // |  ___/| |  | | |   \   /| | |_ | |  | | . ` |
  // | |    | |__| | |____| | | |__| | |__| | |\  |
  // |_|     \____/|______|_|  \_____|\____/|_| \_|
  //  _____  _____       __          _______ _   _  _____ 
  // |  __ \|  __ \     /\ \        / /_   _| \ | |/ ____|
  // | |  | | |__) |   /  \ \  /\  / /  | | |  \| | |  __ 
  // | |  | |  _  /   / /\ \ \/  \/ /   | | | . ` | | |_ |
  // | |__| | | \ \  / ____ \  /\  /   _| |_| |\  | |__| |
  // |_____/|_|  \_\/_/    \_\/  \/   |_____|_| \_|\_____|
                                                       
                                                       
// This draws actual one polygon object on the map
// and applys some expressions

function drawPolygon(allScriptSettings , coords, name ,counter, featureIndex){

  var countrieControl = allScriptSettings.CONTROLLAYER;
  // var scale = allScriptSettings.SCALE;
  // var zorro = allScriptSettings.ZORRO;
  // var addstroke = allScriptSettings.ADDSTROKE;
  var randomColors = allScriptSettings.RANDOMCOLORS;
  var threedee = allScriptSettings.THREEDEE;
  var theColor = allScriptSettings.THECOLOR;
  var tmstmp = allScriptSettings.TIMESTAMPBOOL;
  var timestamp = allScriptSettings.TIMESTAMPVAL;
  
// ------------ get the data ------------
	var pt = new Array();
	for(var i =0;i < coords.length;i++){
		var x = (coords[i][0])*allScriptSettings.SCALE + (allScriptSettings.CURCOMP.width/2);
		var y = (coords[i][1]*-1)*allScriptSettings.SCALE + (allScriptSettings.CURCOMP.height/2);

    // in here the bounding box should be calculated
		pt.push([x,y]);
	}; // close coords loop



var lname = name;
if(allScriptSettings.TIMESTAMPBOOL){
lname = lname +"_"+ allScriptSettings.TIMESTAMPVAL;
};

  if(allScriptSettings.ONTO_SINGLELAYER){

    var layer = allScriptSettings.SINGLELAYER;

  }else{
      // create a new solid or shapelayer
      // with random colors ore the preset coler that comes from above
      if(allScriptSettings.USESHAPELAYERS == true ){
        layer = allScriptSettings.CURCOMP.layers.addShape();
        layer.name = shortenName( lname + " "+counter);
        layer.duration = allScriptSettings.CURCOMP.duration;
        // layer.position.setValue([allScriptSettings.CURCOMP.width/2,allScriptSettings.CURCOMP.height/2]);
        layer.anchorPoint.setValue([allScriptSettings.CURCOMP.width/2,allScriptSettings.CURCOMP.height/2]);

      }else {

        var layer = allScriptSettings.CURCOMP.layers.addSolid(
                            allScriptSettings.THECOLOR,
                            shortenName( lname + " "+counter),
                            allScriptSettings.CURCOMP.width,
                            allScriptSettings.CURCOMP.height,
                            1,
                            allScriptSettings.CURCOMP.duration);
      };
  };

if(allScriptSettings.ZORRO == true){ layer.comment = "*"+name; }; // if the user wishes comments
// and if he wishes 3d layers
if(allScriptSettings.THREEDEE == true){
 if (layer instanceof ShapeLayer){
  // we do nothing. shapelayers dont need collapse transforamtion
 }else{
    layer.collapseTransformation = true;
 };
layer.threeDLayer = true;
};

// taken from http://www.redefinery.com/ae/fundamentals/masks/
// great resource
// given:
// layer = Layer object
//
var masksGroup = null;
if(allScriptSettings.USESHAPELAYERS == true){
  masksGroup = layer("ADBE Root Vectors Group"); // Get the PropertyGroup for the shape
  }else{
  masksGroup = layer("ADBE Mask Parade"); // Get the PropertyGroup for the masks
};
// This PropertyGroup can also be retrieved by using 
// layer.property("Masks") or layer.property("ADBE Mask Parade")
 // Filter out layers that cannot use masks
if (masksGroup != null){

  var mask = null;
  var shapeGroup = null;
  if(allScriptSettings.USESHAPELAYERS == true){
    mask = masksGroup.addProperty("ADBE Vector Shape - Group");
  }else{
    mask = masksGroup.addProperty("ADBE Mask Atom");       // Create a new mask
  };
  
  if (mask != null){

      mask.name = name +" "+counter;

    var s = new Shape();// new shape object
    if (s != null){
            s.vertices = pt;                        // put the path verticies into the shape
            s.closed = true;                        // The close attribute defaults to true 
            if(allScriptSettings.USESHAPELAYERS == true){
            maskShape = mask.property("ADBE Vector Shape");
            }else{   
            maskShape = mask.property("ADBE Mask Shape");  // Get the Mask Shape property for the mask
            };

            maskShape.setValue(s);                   // Change the mask shape (not keyframed)
        };
    };

// if the user wishes strokes
if(allScriptSettings.ADDSTROKE == true ){
    var ccol = allScriptSettings.THECONTOURCOLOR;

    if (allScriptSettings.ONTO_SINGLELAYER == true){
        if(featureIndex == allScriptSettings.FEATURESLENGTH -1 ){
              addStrokeEffect( 
                allScriptSettings.CURCOMP, 
                layer, 
                countrieControl,
                allScriptSettings.ONTO_SINGLELAYER, 
                allScriptSettings.LINKBOOL, 
                ccol);
          };
        } else if(allScriptSettings.ONTO_SINGLELAYER == false){
              addStrokeEffect( 
                allScriptSettings.CURCOMP, 
                layer, 
                countrieControl,
                allScriptSettings.ONTO_SINGLELAYER,
                allScriptSettings.LINKBOOL,
                ccol);
        };
  };// end addstroke

  if(
    (allScriptSettings.ONTO_SINGLELAYER == false) &&
    (allScriptSettings.USESHAPELAYERS   == true) &&
    (allScriptSettings.NOFILLBOOL       != true)
    ){

    var fill = masksGroup.addProperty("ADBE Vector Graphic - Fill");
    fill.property("ADBE Vector Fill Color").setValue(allScriptSettings.THECOLOR);
    fill.name = "fill";
}

return layer;
 };
}; // end drawPolygon



// ------------------------------------------------------------------------------------------------
 //  _____  ______ _____   ____   _____ _____ _______ ____  _   _ 
 // |  __ \|  ____|  __ \ / __ \ / ____|_   _|__   __/ __ \| \ | |
 // | |__) | |__  | |__) | |  | | (___   | |    | | | |  | |  \| |
 // |  _  /|  __| |  ___/| |  | |\___ \  | |    | | | |  | | . ` |
 // | | \ \| |____| |    | |__| |____) |_| |_   | | | |__| | |\  |
 // |_|  \_\______|_|     \____/|_____/|_____|  |_|  \____/|_| \_|
 //           _   _  _____ _    _  ____  _____  
 //     /\   | \ | |/ ____| |  | |/ __ \|  __ \ 
 //    /  \  |  \| | |    | |__| | |  | | |__) |
 //   / /\ \ | . ` | |    |  __  | |  | |  _  / 
 //  / ____ \| |\  | |____| |  | | |__| | | \ \ 
 // /_/    \_\_| \_|\_____|_|  |_|\____/|_|  \_\
 
 // this part is taken from the following script                                             
 // many thanx - great resource
 // i never could have written that myself!
 // thank you thank you thank you
 // Name:
 //  RepositionAnchorPoint
 // Version:
 //  3.3 (2 Nov 2011) by Lloyd Alvarez
 // Author:
 //  Charles Bordenave
 // a bit rewritten for my needs
 // have a look at the original
 // http://aescripts.com/repositionanchorpoint/

function repositionAnchor(layer){
    

    var bBox = calcBBoxOflayer(layer);
    if (bBox){
        var anchPt = layer.anchorPoint;
        var pos = layer.position;       
        
        var halfW = bBox.width / 2;
        var halfH = bBox.height / 2;
        var xoffset = bBox.xoffset;
        var yoffset = bBox.yoffset;
            
    // Apply expressions        
        anchPt.expression = 
        "fromWorld(toWorld([" + halfW + "," + halfH + ",0] + [0 *" + halfW + "+" + xoffset + ", 0 *"+ halfH + "+" + yoffset + ",0]));";
        
        pos.expression =
        "try {\r" +
          " parent.fromWorld(toWorld([" + halfW + "," + halfH + ",0] + [0 *" + halfW + "+" + xoffset + ",0 *"+ halfH + "+" + yoffset + ",0]));\r" +
        "}\r" +
        "catch(e)\r" +
        "{\r" + 
        "  toWorld([" + halfW + "," + halfH + ",0] + [0 *" + halfW + "+" + xoffset + ",0 *"+ halfH + "+" + yoffset + ",0]);\r" +
        "}"; 
                    
        // Little refreshing trick
        pos.expressionEnabled = false;
        pos.expressionEnabled = true;
        
        var anchPtVal = anchPt.valueAtTime(0, false);
        anchPt.expression = "";
        
        var posVal = pos.valueAtTime(0, false);
        pos.expression = "";
        
        // Set value
        anchPt.numKeys ? anchPt.setValueAtTime(0, anchPtVal) : anchPt.setValue(anchPtVal);
        pos.numKeys ? pos.setValueAtTime(0, posVal) : pos.setValue(posVal); 
                
                };
    };

// the bounding box is dependend on the layer center and anchor
// 

function BBox (w,h,xoff,yoff) {

    this.width = w;
    this.height = h;
    this.xoffset = xoff;
    this.yoffset = yoff;
};
/**
 * This is pretty deep shit. I bow my head
 * I mean the trick with the new mask on the Shape Layers is already sweet
 * and the vertex checking with min4 and max4... wow! i mean WOW.
 */

function calcBBoxOflayer(layer){
if(layer instanceof ShapeLayer){
layer.selected = true;
  app.executeCommand(2367); // 2367 : app.findMenuCommandId("New Mask")
  var mask = layer.Masks.property(layer.Masks.numProperties);
  var verts = mask.maskShape.value.vertices;
  mask.remove();

  var bbox = new BBox (Math.abs(verts[0][0] - verts[3][0]),Math.abs(verts[0][1] - verts[1][1]),verts[0][0],verts[0][1]);
   
return bbox;


    }else{
var maskGrp = layer.Masks;

var bBox = null;
if (maskGrp.numProperties){
        var T = Infinity;
        var B = -Infinity;
        var L = Infinity;
        var R = -Infinity;
          
        for (var m = 1; m <= maskGrp.numProperties; m++){
          var mask = maskGrp.property(m);
          var maskShape = mask.maskShape;
            
          var shape = maskShape.valueAtTime(0, false);
          var verts = shape.vertices;
          var intan = shape.inTangents;
          var outtan = shape.outTangents;

          for (var i = 0; i < verts.length; i++){
            T = min4(T, verts[i][1], verts[i][1]+intan[i][1], verts[i][1]+outtan[i][1]);
            B = max4(B, verts[i][1], verts[i][1]+intan[i][1], verts[i][1]+outtan[i][1]);
            L = min4(L, verts[i][0], verts[i][0]+intan[i][0], verts[i][0]+outtan[i][0]);
            R = max4(R, verts[i][0], verts[i][0]+intan[i][0], verts[i][0]+outtan[i][0]);
          };// close i loop
          }; //close m loop
        bBox = new BBox(R-L,B-T,L,T);
      }; // close maskGrp.numPropeertiws
        
       return bBox;
    };// close else
};



function min4 (n1, n2, n3, n4)
  {
    return (n1 < n2 && n1 < n3 && n1 < n4) ? n1 : 
        ((n2 < n1 && n2 < n3 && n2 < n4) ? n2 :
        ((n3 < n1 && n3 < n2 && n3 < n4) ? n3 : n4));           
  }; 

  // Computes the maximum value between four numbers
function max4(n1, n2, n3, n4)
  {
    return (n1 > n2 && n1 > n3 && n1 > n4) ? n1 : 
        ((n2 > n1 && n2 > n3 && n2 > n4) ? n2 :
        ((n3 > n1 && n3 > n2 && n3 > n4) ? n3 : n4));           
  };

// ------------------------------------------------------------------------------------------------




// ------------ AE Expresion functions ------------

function buildExpressionObj(effectName,controllerMatchName,compname,controlname){

  var str = "comp(\""+compname+"\").layer(\""+ controlname+"\").effect(\""+effectName+"\")(\""+controllerMatchName+"\")";

  return str;
};
function addStrokeEffect(curComp, layer, countrieControl, onto_singlelayer, linkProps,contourColor){
app.beginSuppressDialogs();// dont want any warnings

 if(linkProps==true){
    var theExpressions = {
      "color" :   buildExpressionObj("stroke color","ADBE Color Control-0001",    curComp.name,countrieControl.name),
      "width":    buildExpressionObj("stroke weight","ADBE Slider Control-0001",  curComp.name,countrieControl.name), 
      "opacity":  buildExpressionObj("stroke opacity","ADBE Slider Control-0001", curComp.name,countrieControl.name),
      "hardness": buildExpressionObj("brush hardness","ADBE Slider Control-0001", curComp.name,countrieControl.name), 
      "start":    buildExpressionObj("stroke start","ADBE Slider Control-0001",   curComp.name,countrieControl.name), 
      "end":      buildExpressionObj("stroke end","ADBE Slider Control-0001",     curComp.name,countrieControl.name), 
      "spaces":   buildExpressionObj("stroke spaces","ADBE Slider Control-0001",  curComp.name,countrieControl.name)
    };
 };


if(layer instanceof ShapeLayer){
  var stroke = layer("ADBE Root Vectors Group").addProperty("ADBE Vector Graphic - Stroke");
  stroke.name = "stroke";

  if((onto_singlelayer == false) &&(linkProps==true)) {
        setStrokePropertyExpression(stroke, "ADBE Vector Stroke Color",theExpressions.color);
        setStrokePropertyExpression(stroke, "ADBE Vector Stroke Width",theExpressions.width);
        setStrokePropertyExpression(stroke, "ADBE Vector Stroke Opacity",theExpressions.opacity);
  };

}else{
    var stroke = layer("ADBE Effect Parade").addProperty("ADBE Stroke");// add the effect
    if((onto_singlelayer == false) &&(linkProps==true)){
        setStrokePropertyExpression(stroke, "ADBE Stroke-0002", theExpressions.color);
        setStrokePropertyExpression(stroke, "ADBE Stroke-0003", theExpressions.width);
        setStrokePropertyExpression(stroke, "ADBE Stroke-0005", theExpressions.opacity);
        setStrokePropertyExpression(stroke, "ADBE Stroke-0008", theExpressions.start);
        setStrokePropertyExpression(stroke, "ADBE Stroke-0009", theExpressions.end);
        setStrokePropertyExpression(stroke, "ADBE Stroke-0006", theExpressions.spaces);
      };
// add some expressions to control the strokes from the master comp with the stroke controler
}; // close else

if(linkProps == false){
  if(layer instanceof ShapeLayer ){
    layer("ADBE Root Vectors Group").property("stroke").property("ADBE Vector Stroke Color").setValue(contourColor);
  }else{
    layer("ADBE Effect Parade").property("ADBE Stroke").property("ADBE Stroke-0002").setValue(contourColor);
  };
};

app.endSuppressDialogs(false);
};


function setStrokePropertyExpression (prop , propname, expr ){
if (prop.property(propname).canSetExpression) {  
      prop.property(propname).expression = expr;// this is the spaces
      prop.property(propname).expressionEnabled = true;
  };
};

/**
 *  this creates a null object with some expression controllers
 *  using match names
 */ 

function addStrokeController (curComp, zorro , useshapelayers, theContourColor){

var ctrl              = curComp.layers.addNull();
    ctrl.name         = "GEOJson control";
    ctrl.source.name  = "GEOJson control";

var color_ctrl        = ctrl("ADBE Effect Parade").addProperty("ADBE Color Control");
    color_ctrl.name   = "stroke color";
    color_ctrl("ADBE Color Control-0001").setValue(theContourColor);

var strokeWeight_ctrl       = ctrl("ADBE Effect Parade").addProperty("ADBE Slider Control");
    strokeWeight_ctrl.name  = "stroke weight";
    strokeWeight_ctrl.property("ADBE Slider Control-0001").setValue(2);

var opacity_ctrl            = ctrl("ADBE Effect Parade").addProperty("ADBE Slider Control");
    opacity_ctrl.name       = "stroke opacity";
    opacity_ctrl.property("ADBE Slider Control-0001").setValue(100);

if(!useshapelayers){
  var brush_hardness_ctrl       = ctrl("ADBE Effect Parade").addProperty("ADBE Slider Control");
      brush_hardness_ctrl.name  = "brush hardness";

  var start_ctrl                = ctrl("ADBE Effect Parade").addProperty("ADBE Slider Control");
      start_ctrl.name           = "stroke start";

  var end_ctrl                  = ctrl("ADBE Effect Parade").addProperty("ADBE Slider Control");
      end_ctrl.name             = "stroke end";
      end_ctrl.property("ADBE Slider Control-0001").setValue(100);

  var spaces_ctrl               = ctrl("ADBE Effect Parade").addProperty("ADBE Slider Control");
      spaces_ctrl.name          = "stroke spaces";
    };

if(zorro){
      ctrl.comment = "stroke control";
    };
    
    ctrl.locked = true; // this is to be shure that the controller stays in the world map comp
return ctrl;
};


//~   _____  _____  ______  _____  ____  __  __ _____ _____ _   _  _____ 
//~  |  __ \|  __ \|  ____|/ ____|/ __ \|  \/  |  __ \_   _| \ | |/ ____|
//~  | |__) | |__) | |__  | |    | |  | | \  / | |__) || | |  \| | |  __ 
//~  |  ___/|  _  /|  __| | |    | |  | | |\/| |  ___/ | | | . ` | | |_ |
//~  | |    | | \ \| |____| |____| |__| | |  | | |    _| |_| |\  | |__| |
//~  |_|    |_|  \_\______|\_____|\____/|_|  |_|_|   |_____|_| \_|\_____|
//~                                                                      
                                                                     
function precomper(arrOLayers,curComp, thefolder,name, comment , zorro,threedee,tmstmp,timestamp){
    
var layerIndices = new Array(); // precompose takes layer inidcies
// loop thru a list of layer
for(var l in arrOLayers){
// and push their index into an array
    layerIndices[layerIndices.length] = arrOLayers[l].index;
  };
var lname = name;
if(tmstmp){
    lname = lname +"_"+timestamp;
  };
// now precompose the result       
var newComp = curComp.layers.precompose(layerIndices,shortenName( lname), true );
// it is the selected layer
var preCompedLayer = curComp.selectedLayers[0];
// make it also 3D
if(threedee){
    preCompedLayer.collapseTransformation = true;
    preCompedLayer.threeDLayer = true;
  };
// and add comments
if(zorro){
    preCompedLayer.comment = "*"+comment
  };

newComp.parentFolder = thefolder;// houskeeping the project
};


//~    _____  ____  _       ____  _____   _____ 
//~   / ____|/ __ \| |     / __ \|  __ \ / ____|
//~  | |    | |  | | |    | |  | | |__) | (___  
//~  | |    | |  | | |    | |  | |  _  / \___ \ 
//~  | |____| |__| | |____| |__| | | \ \ ____) |
//~   \_____|\____/|______|\____/|_|  \_\_____/ 
//~                                             
                                            

// ------------ color creation ------------
// builds colors based on input 
function colors_builder(len, degrees, s, l ,offset, step){
  
         

    var hue = (offset + ((degrees/(len +1)) * step))%360;
    var rgb = color_hsl2rgb(hue, s, l);

    var colRGB    = new Array();
        colRGB[0] = rgb.r;
        colRGB[1] = rgb.g;
        colRGB[2] = rgb.b;

// AE needs values betweeon 0 and 1
// the values returned are between 0 and 255
 
    var r = colRGB[0]/255; 
    var g = colRGB[1]/255;
    var b = colRGB[2]/255;
  return [r,g,b];
};
 // ------------ this is some wired stuff i dont realy understand but it works ------------
// color converiosn found here
// http://www.codingforums.com/showthread.php?t=11156

function color_hsl2rgb(h, s, l) {
  var m1, m2, hue;
  var r, g, b
  s /=100;
  l /= 100;
  if (s == 0)
    r = g = b = (l * 255);
  else {
    if (l <= 0.5)
      m2 = l * (s + 1);
    else
      m2 = l + s - l * s;
    m1 = l * 2 - m2;
    hue = h / 360;
    r = color_HueToRgb(m1, m2, hue + 1/3);
    g = color_HueToRgb(m1, m2, hue);
    b = color_HueToRgb(m1, m2, hue - 1/3);
  };
  return {r: r, g: g, b: b};
};

function color_HueToRgb(m1, m2, hue) {
  var v;
  if (hue < 0)
    hue += 1;
  else if (hue > 1)
    hue -= 1;

  if (6 * hue < 1)
    v = m1 + (m2 - m1) * hue * 6;
  else if (2 * hue < 1)
    v = m2;
  else if (3 * hue < 2)
    v = m1 + (m2 - m1) * (2/3 - hue) * 6;
  else
    v = m1;

  return 255 * v;
};
 // ------------ end of wired stuff i dont realy understand ------------

// END OF SCRIPT
}